/**
 * @file    mg32_dbg.c
 * @author  MegawinTech Application Team
 * @brief   This file contains all the DBG firmware functions 
 */

/* Define to prevent recursive inclusion -----------------------------------------------------------------------------*/
#define _MG32_DBG_C

/* Files includes ----------------------------------------------------------------------------------------------------*/
#include "mg32_dbg.h"

/** @addtogroup MG32_StdPeriph_Driver
  * @{
  */

/** @addtogroup DBG
  * @{
  */

/** @defgroup DBG_Private_Defines
  * @{
  */

/**
  * @}
  */

/** @defgroup DBG_Private_Functions
  * @{
  */

/**
  * @brief  Enables or disables the specified DBG peripheral.
  * @param  periph: DBG peripheral.
  *     @arg DBGMCU_SLEEP          
  *     @arg DBGMCU_IWDG_STOP 
  *     @arg DBGMCU_TIM1_STOP
  *     @arg DBGMCU_TIM2_STOP  
  *     @arg DBGMCU_TIM1_PWM_OFF         
  *     @arg DBGMCU_TIM2_PWM_OFF   
  *     @arg DBGMCU_TIM14_STOP   
  *     @arg DBGMCU_TIM13_STOP  
  *     @arg DBGMCU_TIM6_STOP  
  * @param  state: new state of the specified DBG peripheral.
  *         This parameter can be: ENABLE or DISABLE.
  * @retval None.
  */
void DBGMCU_Configure(uint32_t periph, FunctionalState state)
{
    (state) ? \
    (DBGMCU->CR |=  periph) : \
    (DBGMCU->CR &= ~periph);
}

/**
  * @brief  Returns the device identifier..
  * @param  None.
  * @retval return the device Device identifier.
  */
uint32_t DBGMCU_GetDeviceIDCode(void)
{
    return (uint32_t)DBGMCU->IDCODE;
}

/**
  * @}
  */

/**
  * @}
  */

/**
  * @}
  */
